import copy
import pandas as pd
import numpy as np

import os

from datetime import date
from dateutil.relativedelta import relativedelta as rd
from flask import Flask, request
from flask_cors import CORS, cross_origin
from flask.helpers import send_from_directory


app = Flask(__name__, static_folder='./frontend/build', static_url_path='')
cors = CORS(app)

#----------------------------------------------------------------------------------------------------------------------#
try:
    if os.path.abspath(__file__).find('stgadfileshare001') == -1:
        host = 'localhost'
        port = 4004
    else:
        host = '0.0.0.0'
        port = 8103
except:
    host = 'localhost'
    port = 4004



@app.route('/')
@cross_origin()
def serve():
    return send_from_directory(app.static_folder, 'index.html')

if __name__ == '__main__':
    app.run(debug=False, host=host, port=port)
